###########################
# SET BASELINE PARAMETERS #
###########################

PAR <- list(
  
  # Input Data Paths. --------------------------------------------------------------------
  
  ## For historic data, the number suffix of file names refers to the maximal year
  ## covered. For projections/scenarios, the suffix refers to the year in which they have 
  ## been produced.
  
  # Current STATPOP release.
  in_pop  = "data/input/pop_hist_23.csv",
  # Current pension registry extract.
  in_rr   = "data/input/pension_registry_24.csv",
  # Current BFS population scenario.
  in_scen = "data/input/pop_scenario_25.csv",
  # Widow pension projections from separate BSV internal model (source: Thomas Borek @BSV, 
  # mathematics department).
  in_wid  = "data/input/widow_proj_25.csv",
  # Current legal minimal pension projections.
  in_mp   = "data/input/minpen_proj_25.csv",
  # Current inflation projections.
  in_eck  = "data/input/prices_proj_25.csv",
  # Historical inflation data.
  in_inf  = "data/input/prices_hist_24.csv",
  # Current ZAS Abschlussrechnung.
  in_zas  = "data/input/totexp_hist_24.csv",
  # Data for Liechtenstein model calculations (derived from pension registry).
  in_lim  = "data/input/hist_mort_pens_23.csv",
  # Path to exogenous projections for the effects of the reform AHV 21, excluding savings  
  # due to the increased reference age for women. Only used if parameter 'ahv21' is set to
  # TRUE (source: projection of cohort-based, internal Delfin expenditure model).
  in_ahv21 = "data/input/ahv21_norefage_25.csv",
  
  # Parameters. --------------------------------------------------------------------------
  
  # Projection interval *including* the current year.
  pint  = 2024:2040,
  # Selection of BFS demographic scenario edition.
  scen = "2025",
  # Respect 13th AHV pension payment from 2026 onwards.
  ahv13 = TRUE,
  # # Include exogenous AHV21 cost vector produced by cohort-based Delfin Ausgabenmodell
  # # (only includes effects *besides* savings due to Referenzalter shifts for women).
  # ahv21 = TRUE,
  # Deflate results according to current Bundes projections.
  real  = TRUE,
  # Reference ages in multiples of years by sex, starting from GO in current year (first
  # element in parameter 'pint'). Beyond the current year, only dates where changes occur 
  # must be provided. The set default respects the reference age shifts for women due to
  # the reform AHV 21.
  reftab = 
    tribble(
      ~ year, ~ sex,     ~ refage,
      2024,   "f",       64      ,
      
      # Reform AHV 21.
      2025,   "f",       64 + 1/4,
      2026,   "f",       64 + 2/4,
      2027,   "f",       64 + 3/4,
      2028,   "f",       64 + 4/4,

      2024,   "m",       65),
  # Conduct cross-validation (CV) to fix trend extrapolation data ranges for the count of 
  # pension entitlements abroad as well as the relative mean pension levels both within 
  # and without Switzerland.
  cv = FALSE,
  # Admissible value range for the number of trend estimation points during CV. Parameter
  # 'tr' applies to the projections for the foreign pension counts as well as the relative
  # mean pension levels. Parameter 'tot' applies to the estimated top-up on the pension 
  # sum necessary to arrive at the total AHV expenditures.
  pr = list("tr" = 4:6, "tot" = 4:6),
  # Pooling function within ('err') and across ('glo') k-step error estimates during CV.
  err = function(pred, obs) abs(pred - obs),
  glo = function(x) mean(x),
  # Length of out-of-sample prediction horizon during CV.
  out = 10,
  # Save output as CSV file.
  write = TRUE,
  # Simulate uncertainty bands in addition to the reference projection.
  bands = TRUE
)
