################################################################################
# LOAD PACKAGES AND SCRIPTS IN SEQUENCE TO PRODUCE AHV EXPENDITURE PROJECTIONS #
################################################################################

# Preamble. ------------------------------------------------------------------------------

# Load necessary packages.
invisible(
  lapply(c("tidyverse", "simputation", "readxl", "rsample", "broom", "strucchange"), 
  library, character.only = TRUE))

# Suppress variable type guessing messages from 'readr' functions.
options(readr.show_col_types = FALSE)

# Calculations. --------------------------------------------------------------------------

# Define helper functions.
source("scripts/other/aux_fun.R")

# Load parameters (e.g. input data paths, modelling of upcoming reforms, real versus
# nominal output).
source("scripts/model/1_initialize_parameters.R")

# Read and process input data.
source("scripts/model/2_prepare_inputs.R")

# Convert BFS demographic scenarios into Swiss pension stock projections and consolidate
# input data into analysis table.
source("scripts/model/3_adjust_scenarios.R")

# Conduct cross-validation for linear trend extrapolations of the foreign pension stocks
# as well as the foreign/Swiss mean pension levels relative to the legal minimal pension.
# The output are the optimal year ranges of historic data used to extrapolate the 
# explanatory variables (see 'Trendpunkte' in the Methodenbeschrieb). Must be run at least 
# once (results are stored as 'data/output/RANGE.RData'). This step has been made optional 
# to save computation time.
if (PAR$cv)
  source("scripts/model/4_cross-validation.R")

# Produce reference projection of the total AHV expenditures. Results are printed unless
# uncertainty bands are required as well.
source("scripts/model/5_reference_projection.R", echo = !PAR$bands)

# Simulate 'high' and 'low' expenditure paths in line with the BSV 'Umlage-Szenario'
# concept, and report as well as visualize them in combination with the reference 
# projection.
if (PAR$bands)
  source("scripts/model/6_uncertainty_bands.R", echo = TRUE)

